#version 430

layout (location = 0) in smooth vec3 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec2 fragTexCoords;
layout (location = 3) in vec4 fragPosLightSpace;
layout (location = 4) flat in uvec3 fragInstanceID;
layout (location = 5) in float colorBrightness;

layout (location = 0) out vec4 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition; //last one is also depth
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gShadowVisibility;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gPhysical;

layout(binding = 1, rgba16f) uniform readonly restrict image2D playerTex;

uniform mat4 view;

uniform int sunID;
uniform int modelID;

uniform vec3 lightDir;

float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}




void main(){
 
//do shadow visibility here

	gShadowVisibility.xyz = (fragPosLightSpace.xyz / fragPosLightSpace.w) * 0.5 + 0.5;

	float playerID = float(fragInstanceID.z);

	gAlbedoSpec.xyzw = vec4(0.0, 1.0, 0.1, 1.0);

	gPhysical.xyzw = vec4(0.0);
	gPhysical.z = 0.5;

	gViewPosition.xyz = fragViewPos.xyz;

	gViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

	gNormal = normalize(fragNormal.xyz);
	gInstanceID = fragInstanceID.xy;



	
}